***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

* Relative price fluctuations (Shock shocks)
g z			= CPI - Median
* 12-month average
gen z_12ma	= (1/12)*(z + z[_n-1] + z[_n-2] + z[_n-3] + z[_n-4] + z[_n-5] + z[_n-6] + z[_n-7] + z[_n-8] + z[_n-9] + z[_n-10] + z[_n-11])

* Overall sample
keep if (t>=tm(1960m1)) & (t<=tm(2022m9))

***************************************************************
* Headline: CPI Core vs. relative prices
***************************************************************

local start = tm(2020m1)
local end	= tm(2022m9)

preserve
local index = 3
local title = "Monthly Annualized Inflation"
*local title = ""
local ytitle = ""
* Variables
g Headline		= CPI
g Core			= Median
g Shock			= Headline - Core
g zero			= 0
* Chart
keep if t>=`start' & t<=`end'
sum t
local t0 = r(min)
local t1 = r(max)-2
twoway (rarea Headline zero t, color(red) lwidth(none)) (rarea Core Shock t, color(red) lwidth(none)) (rarea Core zero t, color(midblue) lwidth(none)) ///
(line Headline t, lcolor(black) lwidth(medthick) mcolor(black) legend(order(2 3 4)) legend(label(2 "Headline-inflation shocks")) legend(label(3 "Core inflation")) ///
xmtick(#31) xlabel(`t0'(12)`t1', format(%tmCY)) xlabel(,labsize(medium)) ylabel(,labsize(medium)) title("`title'") xtitle("") ytitle("") ///
legend(row(3) symxsize(4) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(4 3 2)) ///
legend(size(medium)) ///
xsize(4) saving(`index', replace))
outsheet Headline Core Shock t using "results\charts\Figure 1 Panel A.xls", replace
restore

preserve
local index = 4
local title = "12-month Inflation"
local ytitle = ""
* Variables
g Headline		= CPI_12
g Core			= Median_12
g Shock		= Headline - Core
g zero			= 0
* Chart
keep if t>=`start' & t<=`end'
sum t
local t0 = r(min)
local t1 = r(max)-2
twoway (rarea Headline zero t, color(red) lwidth(none)) (rarea Core Shock t, color(red) lwidth(none)) (rarea Core zero t, color(midblue) lwidth(none)) ///
(line Headline t, lcolor(black) lwidth(medthick) mcolor(black) legend(order(2 3 4)) legend(label(2 "Headline-inflation shocks")) legend(label(3 "Core inflation")) ///
xmtick(#31) xlabel(`t0'(12)`t1', format(%tmCY)) xlabel(,labsize(medium)) ylabel(,labsize(medium)) title("`title'") xtitle("") ytitle("") ///
legend(row(3) symxsize(4) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(4 3 2)) ///
legend(size(medium)) saving(`index', replace))
outsheet Headline Core Shock t using "results\charts\Figure 1 Panel B.xls", replace
restore

graph combine 3.gph 4.gph, xsize(6)

clist t CPI_12 Median_12 if t>=tm(2020m12), noobs

* Change in headline: December 2020 - Septmeber 2022
sum CPI_12 if t==tm(2020m12)
local start = r(mean)
sum CPI_12 if t==tm(2022m9)
local end = r(mean)
di(`end' - `start')

* Change in core: December 2020 - Septmeber 2022
sum Median_12 if t==tm(2020m12)
local start = r(mean)
sum Median_12 if t==tm(2022m9)
local end = r(mean)
di(`end' - `start')


